#ifndef __DM_CRESNET_MASTER_H__
#define __DM_CRESNET_MASTER_H__

/**
 *
 * \file        cresnet_master.h
 *
 * \brief
 *
 * \author      Pete McCormick
 *
 * \date        12/5/2007
 *
 */

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
    BOOL debug;
    //BOOL disableIso8859;
    //UINT8 dest;
    //UINT8 NumStreams;
    UINT32 inQueue;
    UINT8 extra[32];
    UINT32 pktCnt;
    UINT32 allClearCnt;
    UINT32 unknownTypeCnt;
    UINT32 lockId;
    INT32 gotNameReq;  //rwc: was BOOL, keep lastNameReqInfo on 4-byte boundary
    char lastNameReqInfo[256];
}CRESNETMASTER;

extern void CresnetMasterInit(UINT32 inst);
extern CRESNETMASTER * CresnetMasterGetInst(UINT32 inst);
extern UINT32 CresnetMasterGetInstCnt(void);

#ifdef __cplusplus
}
#endif

////////////////////////////////////////////////////////////////////////////////

#endif  //__DM_CRESNET_MASTER_H__
